﻿within AixLib.Fluid.Movers.Compressors.UsersGuide;
class References "References"
  extends Modelica.Icons.References;

  annotation (Documentation(info="<html>
<p>
In the following, the literature used for the compressor library is 
summarised.
</p>
<h4>References regarding compressors in general</h4>
<p>
W. Eifler, E. Schlücker, U. Spicher and G. Will (2009): 
<a href=\"http://dx.doi.org/10.1007/978-3-8348-9302-4\">
Küttner Kolbenmaschinen: Kolbenpumpen, Kolbenverdichter, Brennkraftmaschinen
(in German)</a>. Publisher: <i>Vieweg + Teubner</i>
</p>
<p>
H. Qiao, R. Radermacher and V. Aute (2010): 
<a href=\"http://docs.lib.purdue.edu/iracc/1090\"> A review for numerical simulation 
of vapor compression systems</a>. In: <i>International 
Refrigeration and Air Conditioning Conference</i>
</p>
<p>
P.C. Hanlon (2011): 
<a href=\"https://apvgn.pt/wp-content/uploads/compressor_handbook_hanlon.pdf\">
Compressor Handbook</a>. Publisher: <i>McGraw-Hill</i>
</p>
<p>
V. A. Cara Martin and R. Radermacher (2015): 
<a href=\"http://www.ahrinet.org/App_Content/ahri/files/RESEARCH/Technical%20Results/AHRI-8013_Final_Report.pdf\">
AHRI Project 8013: A Study of Methods to Represent Compressor Performance 
Data over an Operating Envelope Based on a Finite Set of Test Data</a>. 
Publisher: <i>Air-Conditioning, Heating, and Refrigeration Institute (AHRI)</i>
</p>
<h4>References regarding engine efficiencies</h4>
<p>
I.D. Jähnig, D. Reindl and S.A. Klein, S. A. (2000): 
<a href=\"https://www.researchgate.net/publication/288676460_Semi-empirical_method_for_representing_domestic_refrigeratorfreezer_compressor_calorimeter_test_data\">
Semi-empirical method for representing domestic refrigerator/freezer 
compressor calorimeter test data</a>.
</p>
<p>
M.-E Duprez, E. Dumont and M. Fr&egrave;re (2007): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S0140700706002477\">
Modelling of reciprocating and scroll compressors</a>. In: <i>International 
Journal of Refrigeration 30(5)</i>, S. 873&ndash;886
</p>
<p>
E. Kinab, D. Marchio, P. Rivi&egrave;re and A. Zoughaib (2010): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S0378778810002239\">
Reversible heat pump model for seasonal performance optimization</a>. In: 
<i>Energy and Buildings 42(12)</i>, S. 2269&ndash;2280
</p>
<p>
J.M. Mendoza-Miranda, A. Mota-Babiloni, J.J. Ram&iacute;rez-Minguela, 
V.D. Mu&ntilde;oz-Carpio, M. Carrera-Rodr&iacute;guez, 
J. Navarro-Esbr&iacute; and C. Salazar-Hern&aacute;ndez (2016): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S036054421631163X\">
Comparative evaluation of R1234yf, R1234ze(E) and R450A as 
alternatives to R134a in a variable speed reciprocating 
compressor</a>. In: <i>Energy 114</i>, S. 753&ndash;766
</p>
<p>
M. Engelpracht (2017): Development of modular and scalable simulation
models for heat pumps and chillers considering various refrigerants.
<i>Master Thesis</i>
</p>
<h4>References regarding volumetric efficiencies</h4>
<p>
J.H. Darr and R.R. Crawford (1992): 
<a href=\"https://www.researchgate.net/publication/288676460_Semi-empirical_method_for_representing_domestic_refrigeratorfreezer_compressor_calorimeter_test_data\">
Modeling of an Automotive Air Conditioning Compressor 
Based on Experimental Data: ACRC Technical Report 14</a>. 
Publisher: <i>Air Conditioning and Refrigeration Center. 
College of Engineering. University of Illinois at 
Urbana-Champaign.</i>
</p>
<p>
F. Karlsson (2007): 
<a href=\"https://www.sp.se/sv/units/risebuilt/energy/Documents/ETk/Karlsson_Capacity_control_residential_HP_heating_systems.pdf\">
Capacity Control of Residential Heat Pump Heating Systems</a>. In: <i>PhD thesis</i>
</p>
<p>
R. Zhou, T. Zhang, J. Catano, J.T. Wen, G.J. Michna, 
Y. Peles, and M.K. Jensen, M. K. (2010): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S135943111000219X\">
The steady-state modeling and optimization of a refrigeration 
system for high heat flux removal</a>. In: 
<i>Applied Thermal Engineering 30(16)</i>, S. 2347&ndash;2356
</p>
<p>
E. Kinab, D. Marchio, P. Rivi&egrave;re and A. Zoughaib (2010): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S0378778810002239\">
Reversible heat pump model for seasonal performance optimization</a>. In: 
<i>Energy and Buildings 42(12)</i>, S. 2269&ndash;2280
</p>
<p>
W. Li (2013): 
<a href=\"http://www.merl.com/publications/docs/TR2017-055.pdf\">
Simplified steady-state modeling for variable speed compressor</a>. 
In: <i>Applied Thermal Engineering 50(1)</i>, S. 318&ndash;326
</p>
<p>
J.M. Mendoza-Miranda, A. Mota-Babiloni, J.J. Ram&iacute;rez-Minguela, 
V.D. Mu&ntilde;oz-Carpio, M. Carrera-Rodr&iacute;guez, 
J. Navarro-Esbr&iacute; and C. Salazar-Hern&aacute;ndez (2016): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S036054421631163X\">
Comparative evaluation of R1234yf, R1234ze(E) and R450A as 
alternatives to R134a in a variable speed reciprocating 
compressor</a>. In: <i>Energy 114</i>, S. 753&ndash;766
</p>
<p>
Q. Hongtao, C.R. Laughman, D.J. Burns and S.A. Bortoff, (2017): 
<a href=\"http://www.merl.com/publications/docs/TR2017-055.pdf\">
Dynamic Characteristics of an R-410A Multi-split Variable Refrigerant 
Flow Air-conditioning System</a>. In: <i>IEA Heat Pump Conference 2017</i>
</p>
<p>
D. Körner (2017): Development of dynamic compression heat pump models 
to evaluate promising refrigerants considering legal regulations.
<i>Master Thesis</i>
</p>
<p>
M. Engelpracht (2017): Development of modular and scalable simulation
models for heat pumps and chillers considering various refrigerants.
<i>Master Thesis</i>
</p>

<h4>References regarding isentropic efficiencies</h4>
<p>
J.H. Darr and R.R. Crawford (1992): 
<a href=\"https://www.researchgate.net/publication/288676460_Semi-empirical_method_for_representing_domestic_refrigeratorfreezer_compressor_calorimeter_test_data\">
Modeling of an Automotive Air Conditioning Compressor 
Based on Experimental Data: ACRC Technical Report 14</a>. 
Publisher: <i>Air Conditioning and Refrigeration Center. 
College of Engineering. University of Illinois at 
Urbana-Champaign.</i>
</p>
<p>
F. Karlsson (2007): 
<a href=\"https://www.sp.se/sv/units/risebuilt/energy/Documents/ETk/Karlsson_Capacity_control_residential_HP_heating_systems.pdf\">
Capacity Control of Residential Heat Pump Heating Systems</a>. In: <i>PhD thesis</i>
</p>
<p>
J.M. Mendoza-Miranda, A. Mota-Babiloni, J.J. Ram&iacute;rez-Minguela, 
V.D. Mu&ntilde;oz-Carpio, M. Carrera-Rodr&iacute;guez, 
J. Navarro-Esbr&iacute; and C. Salazar-Hern&aacute;ndez (2016): 
<a href=\"http://www.sciencedirect.com/science/article/pii/S036054421631163X\">
Comparative evaluation of R1234yf, R1234ze(E) and R450A as 
alternatives to R134a in a variable speed reciprocating 
compressor</a>. In: <i>Energy 114</i>, S. 753&ndash;766
</p>
<p>
M. Engelpracht (2017): Development of modular and scalable simulation
models for heat pumps and chillers considering various refrigerants.
<i>Master Thesis</i>
</p>
</html>",
revisions="<html>
<ul>
  <li>
  October 19, 2017, by Mirko Engelpracht:<br/>
  First implementation
  (see <a href=\"https://github.com/RWTH-EBC/AixLib/issues/467\">issue 467</a>).
  </li>
</ul>
</html>"));
end References;
